/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.VWSIMDesignerPreferences;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeNotifier;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.event.VWMapChangeEventNotifier;
import filenet.vw.toolkit.design.property.event.VWSelectionChangeEventNotifier;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.VWToolbarActionNotifier;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Date;
import java.util.Vector;

public class VWSIMPropertyData
implements IVWPropertyData {
    private VWMapChangeEventNotifier m_mapChangeEventNotifier = null;
    private VWSIMPropertyChangeNotifier m_propertyChangeEventNotifier = null;
    private VWSelectionChangeEventNotifier m_selectionChangeEventNotifier = null;
    private VWToolbarActionNotifier m_toolbarActionNotifier = null;
    private Frame m_parentFrame = null;
    private VWSessionInfo m_sessionInfo = null;
    private boolean m_bDirty = false;
    private VWScenarioDefinition m_scenarioDefinition = null;
    private VWWorkflowDefinition m_selectedWorkflowDefinition = null;
    private IVWIDMItem m_idmContext = null;
    private VWSIMDesignerPreferences m_designerPreferences = null;
    private boolean m_replaceInitialDataFields = false;
    private VWSystemConfiguration m_systemConfiguration = null;
    private String m_sdfFileContents = null;

    public VWSIMPropertyData(Frame parentFrame, VWSessionInfo sessionInfo) {
        this.m_parentFrame = parentFrame;
        this.m_sessionInfo = sessionInfo;
    }

    public void releaseReferences() {
        if (this.m_mapChangeEventNotifier != null) {
            this.m_mapChangeEventNotifier.releaseReferences();
            this.m_mapChangeEventNotifier = null;
        }
        if (this.m_propertyChangeEventNotifier != null) {
            this.m_propertyChangeEventNotifier.releaseReferences();
            this.m_propertyChangeEventNotifier = null;
        }
        if (this.m_selectionChangeEventNotifier != null) {
            this.m_selectionChangeEventNotifier.releaseReferences();
            this.m_selectionChangeEventNotifier = null;
        }
        if (this.m_toolbarActionNotifier != null) {
            this.m_toolbarActionNotifier.releaseReferences();
            this.m_toolbarActionNotifier = null;
        }
        this.m_parentFrame = null;
        this.m_sessionInfo = null;
        this.m_scenarioDefinition = null;
        this.m_selectedWorkflowDefinition = null;
        this.m_idmContext = null;
        this.m_designerPreferences = null;
    }

    public Frame getParentFrame() {
        return this.m_parentFrame;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }

    public VWScenarioDefinition getScenarioDefinition() {
        return this.m_scenarioDefinition;
    }

    public void setScenarioDefinition(VWScenarioDefinition scenarioDefinition, boolean bNewScenario) {
        this.m_scenarioDefinition = scenarioDefinition;
        try {
            VWSIMDesignerPreferences preferences;
            if (bNewScenario && (preferences = this.getDesignerPreferences()) != null && preferences.getShouldCreateDefaultEntries()) {
                this.createDefaultShift();
                this.createDefaultRole();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.getPropertyChangeEventNotifier().notifyPropertyChange(this, 101);
    }

    public VWScenarioShiftDefinition createDefaultShift() throws VWException {
        VWScenarioShiftDefinition defaultShiftDef = null;
        if (this.m_scenarioDefinition != null) {
            try {
                defaultShiftDef = this.m_scenarioDefinition.getShift(VWSIMResource.s_defaultShiftName);
            }
            catch (Exception ex) {
                defaultShiftDef = this.m_scenarioDefinition.createShift(VWSIMResource.s_defaultShiftName);
                defaultShiftDef.setShiftType(1);
                defaultShiftDef.setScheduleType(3);
                defaultShiftDef.setActiveDays(31);
                Date scenarioStartDateTime = (Date)this.m_scenarioDefinition.getStartTime();
                String timeString = VWDateTimeFormat.getTimeString(scenarioStartDateTime);
                long lTimeValue = VWDateTimeFormat.convertTimeStringToSeconds(timeString);
                defaultShiftDef.setStartTime(lTimeValue);
                this.getPropertyChangeEventNotifier().notifyPropertyChange(this, 120, defaultShiftDef);
            }
        }
        return defaultShiftDef;
    }

    public VWScenarioRoleDefinition createDefaultRole() throws VWException {
        VWScenarioRoleDefinition defaultRoleDef = null;
        if (this.m_scenarioDefinition != null) {
            try {
                defaultRoleDef = this.m_scenarioDefinition.getRole(VWSIMResource.s_defaultJobName);
            }
            catch (Exception ex) {
                defaultRoleDef = this.m_scenarioDefinition.createRole(VWSIMResource.s_defaultJobName);
                Vector availableQueueNames = new Vector();
                this.getAvailableQueueNames(availableQueueNames);
                for (int i = 0; i < availableQueueNames.size(); ++i) {
                    defaultRoleDef.createQueueAssignment((String)availableQueueNames.elementAt(i), 3);
                }
                this.getPropertyChangeEventNotifier().notifyPropertyChange(this, 115, defaultRoleDef);
            }
        }
        return defaultRoleDef;
    }

    public VWScenarioRoleAssignment getAvailableRoleAssignment(VWScenarioShiftDefinition shiftDef) throws Exception {
        VWScenarioRoleAssignment roleAssignment;
        block3: {
            roleAssignment = null;
            try {
                roleAssignment = shiftDef.getRoleAssignment(VWSIMResource.s_defaultJobName);
            }
            catch (Exception ex1) {
                VWScenarioRoleAssignment[] roleAssignments = shiftDef.getRoleAssignments();
                if (roleAssignments != null && roleAssignments.length > 0) {
                    roleAssignment = roleAssignments[0];
                }
                VWScenarioRoleDefinition roleDef = null;
                VWScenarioRoleDefinition[] roleDefs = this.m_scenarioDefinition.getRoles();
                roleDef = roleDefs != null && roleDefs.length > 0 ? roleDefs[0] : this.createDefaultRole();
                if (roleDef == null) break block3;
                roleAssignment = shiftDef.createRoleAssignment(roleDef.getName());
            }
        }
        return roleAssignment;
    }

    public void getAvailableQueueNames(Vector availableQueueNames) {
        try {
            if (this.m_systemConfiguration != null) {
                availableQueueNames.addElement("Inbox");
                VWQueueDefinition[] queueDefs = this.m_systemConfiguration.getQueueDefinitions();
                if (queueDefs != null) {
                    for (int i = 0; i < queueDefs.length; ++i) {
                        String name = queueDefs[i].getName();
                        if (VWStringUtils.compare(name, "Conductor") == 0 || availableQueueNames.contains(name) || queueDefs[i].getIsConnectorQueue()) continue;
                        availableQueueNames.addElement(name);
                    }
                }
            } else {
                VWSession session = this.getVWSession();
                if (session != null) {
                    availableQueueNames.addElement("Inbox");
                    String[] queueNames = session.fetchQueueNames(1);
                    if (queueNames != null) {
                        for (int i = 0; i < queueNames.length; ++i) {
                            VWQueue queue;
                            String name = queueNames[i];
                            if (VWStringUtils.compare(name, "Conductor") == 0 || availableQueueNames.contains(name) || (queue = session.getQueue(name)).getIsConnectorQueue()) continue;
                            availableQueueNames.addElement(name);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWorkflowDefinition getSelectedWorkflowDefinition() {
        return this.m_selectedWorkflowDefinition;
    }

    public void setSelectedWorkflowDefinition(VWWorkflowDefinition workflowDefinition) {
        this.m_selectedWorkflowDefinition = workflowDefinition;
        this.getMapChangeEventNotifier().notifyMapChange(554);
    }

    public void setDirty() {
        this.m_bDirty = true;
    }

    public void resetDirty() {
        this.m_bDirty = false;
    }

    public boolean isDirty() {
        return this.m_bDirty;
    }

    public IVWIDMItem getIDMContext() {
        return this.m_idmContext;
    }

    public void setIDMContext(IVWIDMItem idmContext) {
        this.m_idmContext = idmContext;
    }

    public boolean getReplaceInitialDataFields() {
        return this.m_replaceInitialDataFields;
    }

    public void setReplaceInitialDataFields(boolean bReplace) {
        this.m_replaceInitialDataFields = bReplace;
    }

    public void displayWaitCursor() {
        if (this.m_sessionInfo.getParentContainer() != null) {
            this.m_sessionInfo.getParentContainer().setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void restoreDefaultCursor() {
        if (this.m_sessionInfo.getParentContainer() != null) {
            this.m_sessionInfo.getParentContainer().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void repaintContainer() {
        Container mainContainer = this.m_sessionInfo.getParentContainer();
        if (mainContainer != null) {
            mainContainer.invalidate();
            mainContainer.validate();
            mainContainer.repaint();
        }
    }

    public VWSIMDesignerPreferences getDesignerPreferences() {
        if (this.m_designerPreferences == null) {
            this.m_designerPreferences = new VWSIMDesignerPreferences(this.m_parentFrame, this.m_sessionInfo);
            this.m_designerPreferences.initPreferenceSettings();
        }
        return this.m_designerPreferences;
    }

    public void deleteResourceAssignments(VWScenarioResourceDefinition resourceDef) {
        VWScenarioResourceAssignment[] resourceAssignments;
        if (resourceDef != null && (resourceAssignments = resourceDef.getResourceAssignments()) != null) {
            for (int i = 0; i < resourceAssignments.length; ++i) {
                try {
                    VWScenarioRoleAssignment roleAssignment = resourceAssignments[i].getRole();
                    if (roleAssignment == null) continue;
                    roleAssignment.deleteResourceAssignment(resourceAssignments[i].getResourceName());
                    VWScenarioResourceAssignment[] tempResourceAssignments = roleAssignment.getResourceAssignments();
                    if (tempResourceAssignments != null && (tempResourceAssignments == null || tempResourceAssignments.length != 0)) continue;
                    roleAssignment.getShift().deleteRoleAssignment(roleAssignment.getRoleName());
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
    }

    public void deleteRoleAssignments(VWScenarioRoleDefinition roleDef) {
        VWScenarioRoleAssignment[] roleAssignments;
        if (roleDef != null && (roleAssignments = roleDef.getRoleAssignments()) != null) {
            for (int i = 0; i < roleAssignments.length; ++i) {
                try {
                    roleAssignments[i].getShift().deleteRoleAssignment(roleAssignments[i].getRoleName());
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
    }

    public VWMapChangeEventNotifier getMapChangeEventNotifier() {
        if (this.m_mapChangeEventNotifier == null) {
            this.m_mapChangeEventNotifier = new VWMapChangeEventNotifier();
        }
        return this.m_mapChangeEventNotifier;
    }

    public VWSIMPropertyChangeNotifier getPropertyChangeEventNotifier() {
        if (this.m_propertyChangeEventNotifier == null) {
            this.m_propertyChangeEventNotifier = new VWSIMPropertyChangeNotifier();
        }
        return this.m_propertyChangeEventNotifier;
    }

    public VWSelectionChangeEventNotifier getSelectionChangeEventNotifier() {
        if (this.m_selectionChangeEventNotifier == null) {
            this.m_selectionChangeEventNotifier = new VWSelectionChangeEventNotifier();
        }
        return this.m_selectionChangeEventNotifier;
    }

    public VWToolbarActionNotifier getToolbarActionNotifier() {
        if (this.m_toolbarActionNotifier == null) {
            this.m_toolbarActionNotifier = new VWToolbarActionNotifier();
        }
        return this.m_toolbarActionNotifier;
    }

    public VWSystemConfiguration getSystemConfiguration() {
        return this.m_systemConfiguration;
    }

    public void setSystemConfiguration(VWSystemConfiguration sysConfig) {
        this.m_systemConfiguration = sysConfig;
    }

    public String getSdfFileContents() {
        return this.m_sdfFileContents;
    }

    public void setSdfFileContents(String sdfFileContents) {
        this.m_sdfFileContents = sdfFileContents;
    }

    public Frame getMainContainer() {
        return this.m_parentFrame;
    }

    public VWSession getVWSession() {
        if (this.m_sessionInfo != null) {
            return this.m_sessionInfo.getSession();
        }
        return null;
    }

    public VWWorkflowDefinition getWorkflowDefinition() {
        return this.m_selectedWorkflowDefinition;
    }

    public VWWorkflowDefinition getBaseWorkflowDefinition() {
        return null;
    }

    public VWFieldDefinition[] getFields() {
        VWWorkflowDefinition wfDef = this.getWorkflowDefinition();
        if (wfDef != null) {
            try {
                return wfDef.getFields();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    public VWWebServiceUtils getWebServiceUtils() {
        return null;
    }

    public boolean isProcessSimulation() {
        return true;
    }

    public boolean getShowParticipants() {
        return true;
    }
}

